#include <iostream>
#include "SerialCommHelper.h"

/// <summary>
/// This is a callback function that is used to receive mouse data from CSerialCommHelper instance.
/// </summary>
/// <param name="sP">New mouse data object</param>
void DataReceived(StPosition sP)
{
	if (sP.S != INT_MIN)
		std::cout << "S: " << sP.S << " ";

	if (sP.X != INT_MIN)
		std::cout << "X: " << sP.X << " ";

	if (sP.Y != INT_MIN)
		std::cout << "Y: " << sP.Y << " ";

	if (sP.Z != INT_MIN)
		std::cout << "Z: " << sP.Z << " ";

	if (sP.S != INT_MIN || sP.X != INT_MIN || sP.Y != INT_MIN || sP.Z != INT_MIN)
		std::cout << std::endl;
}

/// <summary>
/// Entry point of console application.
/// </summary>
/// <returns></returns>
int main()
{
	std::cout << "VCP Console Test v1.1.4 !\n";
	std::string port;
	
	// Create CSerialCommHelper instance.
	CSerialCommHelper m_theCommPort;
	if (!m_theCommPort.detectPort() || m_theCommPort.ports.size() == 0) {
		std::cout << "Failed to find port.";
		goto endP;
	}
	else {
		// If multiple devices are connected then multiple ports will be detected.
		// For this sample, supposing one device is connected, we connect at index 0.
		for (int cp = 0; cp < m_theCommPort.ports.size(); cp++) {
			port = m_theCommPort.ports[cp];


			std::cout << "Connecting.." << port << std::endl;

			port = "\\\\.\\" + port;
			m_theCommPort.Init(port.c_str(), 9600, 0, 1, 8);

			if (m_theCommPort.IsConnection()) {
				std::cout << "Connected..\n";

				m_theCommPort.Start();
				// use the setDCallback function to subsribe to mouse data updates.
				m_theCommPort.setDCallback(DataReceived);
			}
			else {
				std::cout << "Failed to connect !\n";
				m_theCommPort.UnInit();
			}
		}
	}

endP:
	std::cout << "Press Enter key to disconnect and close.";
	(void)getchar();
	// To unsubscribe and close StMouse device connection, call UnInit().
	m_theCommPort.UnInit();
}

